﻿$(document).ready(function () {
    initImageAreaSelectors();
});

function initImageAreaSelectors() {
    $(".imageMap").each(function () {
        setImageAreaSelectorAreas($(this));
    });

    $(".imageAreaSelector .imageMap .area")
        .on("mouseenter", function () {
            if (!$(this).hasClass("selectedImageArea")) {
                $(this).addClass("highlightedImageArea");
                UpdateImageAreaSelectorAreaColor($(this));
            }
        })
        .on("mouseleave", function () {
            if (!$(this).hasClass("selectedImageArea")) {
                $(this).removeClass("highlightedImageArea");
                UpdateImageAreaSelectorAreaColor($(this));
            }
        });

    $(".imageAreaSelector .imageMap .area").on("click", function () {
        var checkBox = $(":checkbox", $(this));
        var imageMap = $(this).closest(".imageMap");
        var maxAnswers = imageMap.attr("data-maxanswers");
        var selectedChoices = imageMap.data("selectedChoices");

        if (!selectedChoices) {
            selectedChoices = new Array();
        }

        if (checkBox.is(":checked")) {
            selectedChoices = $.grep(selectedChoices, function (value) { return value != checkBox.attr("id"); });
            checkBox.prop("checked", false);
            $(this).removeClass("selectedImageArea");
            $(this).addClass("highlightedImageArea");
        }
        else {
            if (checkBox.attr("data-exclusive") == "true") {
                $(":checkbox", imageMap).prop("checked", false);
                $(".area", imageMap).removeClass("selectedImageArea");
                selectedChoices = new Array();
            }
            else if (maxAnswers != null && maxAnswers > 0 && selectedChoices != null && selectedChoices.length >= maxAnswers) {
                var checkBoxToUncheck = $("#" + selectedChoices[0]);
                var area = checkBoxToUncheck.closest(".area");
                selectedChoices.splice(0, 1);
                checkBoxToUncheck.prop("checked", false);
                area.removeClass("selectedImageArea");
            }

            var exclusiveChoice = $(":checkbox[data-exclusive='true']:checked", imageMap);
            exclusiveChoice.prop("checked", false);
            exclusiveChoice.closest(".area").removeClass("selectedImageArea");
            selectedChoices = $.grep(selectedChoices, function (value) { return value != exclusiveChoice.attr("id"); });

            checkBox.prop("checked", true);
            $(this).removeClass("highlightedImageArea");
            $(this).addClass("selectedImageArea");
            selectedChoices.push(checkBox.attr("id"));
        }
        checkBox.trigger("change");

        $(".area", imageMap).each(function () {
            UpdateImageAreaSelectorAreaColor($(this));
        });

        imageMap.data("selectedChoices", selectedChoices);
    });
}

function UpdateImageAreaSelectorAreaColor(area) {
    var color;

    if (area.hasClass("selectedImageArea")) {
        color = area.attr("data-color");
    }
    else if (area.hasClass("highlightedImageArea")) {
        var imageMap = area.closest(".imageMap");
        color = imageMap.attr("data-highlightcolor");
    }

    if (color) {
        area.css("background-color", color);
    }
    else {
        area.css("background-color", "");
    }
}


function setImageAreaSelectorAreas(imageMap, updateSelectedChoices) {
    imageMap.disableSelection();
    var selectedChoices = new Array();

    $("img", imageMap).imagesLoaded().always(function (instance) {
        $.each(instance.images, function (key, value) {
            var image = $(value.img);
            var width = image.width();
            var height = image.height();
            var imagePosition = image.position();

            var borderLeftWidth = parseInt(image.css("border-left-width").replace("px", ""));
            if (isNaN(borderLeftWidth)) {
                borderLeftWidth = 0;
            }

            var borderTopWidth = parseInt(image.css("border-top-width").replace("px", ""));
            if (isNaN(borderTopWidth)) {
                borderTopWidth = 0;
            }

            $(".area", imageMap).each(function () {
                $(this).width(Math.round(Math.min($(this).attr("data-width") * width, width)));
                $(this).height(Math.round(Math.min($(this).attr("data-height") * height, height)));
                $(this).css("left", Math.ceil(($(this).attr("data-left") * width) + borderLeftWidth + imagePosition.left));
                $(this).css("top", Math.ceil(($(this).attr("data-top") * height) + borderTopWidth + imagePosition.top));

                if (updateSelectedChoices) {
                    var checkBox = $(":checkbox", $(this));

                    if (checkBox.is(":checked")) {
                        selectedChoices.push(checkBox.attr("id"));
                    }
                }
            });
        });
    });

    if (updateSelectedChoices)
        $(this).data("selectedChoices", selectedChoices);
}